/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;

public class RenderUtils {
    private static final int MAX_DEBUG_TEXT_RENDER_DIST_SQUARED = 1024;
    public static final RenderType LINES_GLINT = RenderTypes.access$000();

    public static void renderWhiteOutlineBox(BlockPos posA, BlockPos posB, MatrixStack ms, IVertexBuilder buffer) {
        RenderUtils.renderBox(posA, posB, 1.0f, 1.0f, 1.0f, 1.0f, 0.0, ms, buffer);
    }

    public static void renderBox(BlockPos posA, BlockPos posB, float red, float green, float blue, float alpha, double boxGrow, MatrixStack matrixStack, IVertexBuilder buffer) {
        double minX = (double)Math.min(posA.func_177958_n(), posB.func_177958_n()) - boxGrow;
        double minY = (double)Math.min(posA.func_177956_o(), posB.func_177956_o()) - boxGrow;
        double minZ = (double)Math.min(posA.func_177952_p(), posB.func_177952_p()) - boxGrow;
        double maxX = (double)(Math.max(posA.func_177958_n(), posB.func_177958_n()) + 1) + boxGrow;
        double maxY = (double)(Math.max(posA.func_177956_o(), posB.func_177956_o()) + 1) + boxGrow;
        double maxZ = (double)(Math.max(posA.func_177952_p(), posB.func_177952_p()) + 1) + boxGrow;
        Vector3d viewPosition = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_216785_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-viewPosition.field_72450_a, -viewPosition.field_72448_b, -viewPosition.field_72449_c);
        WorldRenderer.func_228427_a_((MatrixStack)matrixStack, (IVertexBuilder)buffer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)red, (float)green, (float)blue, (float)alpha);
        matrixStack.func_227865_b_();
    }

    public static void renderDebugText(BlockPos pos, List<String> text, MatrixStack matrixStack, boolean forceWhite, int mergeEveryXListElements) {
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        RenderUtils.renderDebugText(pos, text, matrixStack, forceWhite, mergeEveryXListElements, (IRenderTypeBuffer)buffer);
        buffer.func_228461_a_();
    }

    public static void renderDebugText(BlockPos pos, List<String> text, MatrixStack matrixStack, boolean forceWhite, int mergeEveryXListElements, IRenderTypeBuffer buffer) {
        if (mergeEveryXListElements < 1) {
            throw new IllegalArgumentException("mergeEveryXListElements is less than 1");
        }
        EntityRendererManager erm = Minecraft.func_71410_x().func_175598_ae();
        int cap = text.size();
        if (cap > 0 && erm.func_78714_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) <= 1024.0) {
            Vector3d viewPosition = erm.field_217783_c.func_216785_c();
            FontRenderer fontrenderer = erm.func_78716_a();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.75, (double)pos.func_177952_p() + 0.5);
            matrixStack.func_227861_a_(-viewPosition.field_72450_a, -viewPosition.field_72448_b, -viewPosition.field_72449_c);
            matrixStack.func_227863_a_(erm.func_229098_b_());
            matrixStack.func_227862_a_(-0.014f, -0.014f, 0.014f);
            matrixStack.func_227861_a_(0.0, 18.0, 0.0);
            float backgroundTextOpacity = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
            int alphaMask = (int)(backgroundTextOpacity * 255.0f) << 24;
            Matrix4f rawPosMatrix = matrixStack.func_227866_c_().func_227870_a_();
            for (int i = 0; i < cap; i += mergeEveryXListElements) {
                StringTextComponent renderText = new StringTextComponent(mergeEveryXListElements == 1 ? text.get(i) : text.subList(i, Math.min(i + mergeEveryXListElements, cap)).toString());
                float textCenterShift = -fontrenderer.func_238414_a_((ITextProperties)renderText) / 2;
                fontrenderer.func_243247_a((ITextComponent)renderText, textCenterShift, 0.0f, forceWhite ? -1 : 0x20FFFFFF, false, rawPosMatrix, buffer, true, alphaMask, 0xF000F0);
                if (!forceWhite) {
                    fontrenderer.func_243247_a((ITextComponent)renderText, textCenterShift, 0.0f, -1, false, rawPosMatrix, buffer, false, 0, 0xF000F0);
                }
                matrixStack.func_227861_a_(0.0, 10.0, 0.0);
            }
            matrixStack.func_227865_b_();
        }
    }

    public static final class RenderTypes
    extends RenderType {
        private static final RenderType LINES_GLINT = RenderTypes.func_228632_a_((String)"structurize_lines_glint", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.empty())).func_228718_a_(field_239235_M_).func_228726_a_(field_228510_b_).func_228721_a_(field_241712_U_).func_228727_a_(field_228496_F_).func_228714_a_(field_228491_A_).func_228715_a_(field_228492_B_).func_228717_a_(field_228501_K_).func_228728_a_(false));

        public RenderTypes(String nameIn, VertexFormat formatIn, int drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
            super(nameIn, formatIn, drawModeIn, bufferSizeIn, useDelegateIn, needsSortingIn, setupTaskIn, clearTaskIn);
            throw new IllegalStateException();
        }

        static /* synthetic */ RenderType access$000() {
            return LINES_GLINT;
        }
    }
}

